function y = calc_SII_analytical(ene, peak_pos, Gamma, ...
    g0_mech_cav, par)

    function y = chi_opt(w)
        y = 1/(par.opt.K/2 - 1i*(w + par.opt.det));
    end

ene = ene*2*pi;
peak_pos = peak_pos*2*pi;
Gamma = Gamma*2*pi;

for j=1:size(ene, 2)
    % Resonant terms for blue and red detuning
%     y(j) = par.opt.Ke/2*par.opt.nc*par.mech.nb*...
%         (abs(chi_opt(-ene(j)))^2 + abs(chi_opt(ene(j)))^2)*...
%         sum(Gamma.*g0_mech_cav.^2./((ene(j) ...
%         - peak_pos).^2 + (Gamma./2).^2));
    
    % All the terms
    chi_opt_p = chi_opt(ene(j));
    chi_opt_m = chi_opt(-ene(j));
    y(j) = par.opt.Ke/2*par.mech.nb*...
        abs(par.opt.alpha*chi_opt_p - conj(par.opt.alpha)*...
        conj(chi_opt_m)).^2.*...
        sum(Gamma.*g0_mech_cav.^2./((ene(j) ...
        - peak_pos).^2 + (Gamma./2).^2));
end

end